 aR  d  w  mY9      h	 oK    nSystem-wideOsNewBoot: DO;

$SAVE NOLIST
$INCLUDE (`w0`Incs`PlmLits.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Error.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Constant.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Device.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Type.Inc~Text~)
$INCLUDE (`w0`OsIncs`Os.Task.Type.Inc~Text~)
$INCLUDE(DiagMsgTypes.inc~Text~)
$RESTORE


/*                     Literals                   */

DCL sizeBootStack LIT '1000';
DCL addrBootStack LIT '01A000H';


/*                     Variables                  */

DCL cardId				BYTE EXTERNAL;
DCL cardType			BYTE EXTERNAL;
DCL bootTrace			BYTE EXTERNAL;

DCL bootCardId			BYTE EXTERNAL;

DCL osHeader			STRUCTURE
 (checksum	WORD,
  pBuf		PTR,
  pOs		PTR);

DCL oldStackPtr			WORD;
DCL oldStackBase		WORD;
DCL pStack				PTR;
DCL stackOffset			DWORD AT (@pStack);


/*       Arrays, Versions & Copyright Info       */

DCL divisors       (*) BYTE
  DATA (100, 10, 1);

DCL promVersion    (*) BYTE PUBLIC
  DATA ('Prom 3 11/17/84');

DCL copyRight      (*) BYTE PUBLIC
  DATA ('Copyright (c) 1983, 1984, 1985 GRiD Systems Corp.');

$EJECT
/*               External Procedures              */

MakeCheckSum: PROCEDURE (pBuffer, lenBuffer) WORD EXTERNAL;
  DCL lenBuffer WORD;
  DCL pBuffer   PTR;
  END;

ConCharOut: PROCEDURE (char) EXTERNAL;
  DCL char BYTE;
  END;

ConLineOut: PROCEDURE (pLine, lenLine) EXTERNAL;
  DCL lenLine WORD;
  DCL pLine   PTR;
  END;

CpAddressOf: PROCEDURE PTR EXTERNAL;
  END;

CpDisableInterrupt: PROCEDURE (interruptID) EXTERNAL;
  DCL interruptID BYTE;
  END;

CpEnableInterrupt: PROCEDURE (interruptID, mode) EXTERNAL;
  DCL interruptID BYTE;
  DCL mode        BYTE;
  END;

CpEndOfInterrupt: PROCEDURE (interruptID) EXTERNAL;
  DCL interruptID  BYTE;
  END;

CpSetMessageHandler: PROCEDURE (pNewHandler) PTR EXTERNAL;
  DCL pNewHandler PTR;
  END;

CpLogError: PROCEDURE (parm, pMsg) EXTERNAL;
  DCL parm        BYTE;
  DCL pMsg        PTR;
  END;

CpDelay: PROCEDURE (val) EXTERNAL;
  DCL val		  WORD;
  END;

$IF systemType = 0

$EJECT
/* This is Os.BootMaster.PLM.  This resides in    */
/* prom and will try to boot in the following     */
/* order: bubble, winchester, floppy.  It will put*/
/* a character (b, w, f) at the element bootTrace */
/* of promVariables to indicate which device to   */
/* use.  This trace will be used by the main OS.  */

/* Changes (By Tim Wiegman  --  5/1/83)           */

/*   PL.drive is not set since drive is assumed   */
/*   to be 0 and is set to 0 in InitDevice.       */

/*   Things were rearranged such that it is       */
/*   always necessary to call SetUpPL before      */
/*   calling a driver thru entryPoint.            */


/* Changes (By Tim Wiegman  --  7/25/83)          */

/*   Errors are sent to console & display.        */
/*   Boot device is found using FINDB.            */
/*   bootIndex & error are shared static vars.    */

/* Changes (By Tim Wiegman  --  9/13/83)          */

/*   Rearranged order of default boot.            */
/*   Program pbus disks with their parameters.    */

/* Changes (By Dan Maltbie  -- 11/17/84)          */

/*   Changed bootCharacter to be external,        */
/*   and removed keyboard logic for getting       */
/*   boot device character. This is now           */
/*   provided in the boot request message         */

/* Changes (By Tim Wiegman  -- 12/07/84)          */

/*   Added check to prevent booting off of tape   */
/*   device (May be expanded to other non-booting */
/*   devices.)                                    */

/*                   Literals                     */

DCL firstPBusIndex      LIT  '0';
DCL lastPBusIndex       LIT  '7';
DCL firstGPiBIndex      LIT  '8';
DCL lastGPiBIndex       LIT '10';

DCL pbusTapeNumber      LIT '1';


/* numDevices should equal lastGPiBIndex + 1 */

DCL numDevices          LIT '11';

DCL bootStart           LIT '200H';
DCL bootLength          LIT '800H';
DCL systemPageSize      LIT '200H';

DCL readKey             LIT '2';

DCL lowercaseBit LIT '20H';
$EJECT

/*                Static Variables                */

DCL bootCharacter       BYTE EXTERNAL; /* djm */
DCL bootIndex           WORD;
DCL bootFirst           WORD;
DCL bootLast            WORD;
DCL pageSize            WORD;
DCL error               WORD;
DCL errors (numDevices) WORD;
DCL entryPoint          PTR;
DCL bootPtr             PTR;
$IF notUsed
DCL oldKeyHandler       PTR;  /* djm */
$ENDIF
DCL pPromVars           PTR;
DCL pl                  ParamListType;
DCL gpibStatus          STRUCTURE
 (request                 BYTE,
  length                  WORD);

DCL promVars            BASED pPromVars PromVariablesType;

DCL buffer (1)   BYTE                  AT (20000H);
DCL physPageZero PhysPageZeroType      AT (20000H);
DCL bootAddress  BYTE                  AT (20006H);

/* Note: The first parameters of setStatus       */
/* overlap the parameters of msStatus.           */

DCL msStatus     MsStatusType          AT (20800H);
DCL setStatus    LowLevelSetStatusType AT (20800H);

/* Note: The last parameters of setStatus        */
/* overlap the parameters of moreStatus, except  */
/* moreStatus has one additional byte.  The only */
/* reason that this is acceptable (?) in this    */
/* case is that these variables are all located  */
/* out in memory land.                           */

DCL moreStatus   GetMoreStatusType     AT (@setStatus.interleave);


/*              Arrays and Structures             */

DCL bootCharacters (*) BYTE
  DATA ('0', '1', '2', '3', '4', '5', '6', '7', 'c', 'f', 'w');

DCL gpibAddresses  (*) BYTE
  DATA (6, 5, 4);

/* GPiB */

GPIBDriver: PROCEDURE (req, pPl, pError) EXTERNAL;
  DCL req    WORD;
  DCL pPl    PTR;
  DCL pError PTR;
  END;

/* Chip, Floppy and Winchester */

OsDskDriver: PROCEDURE (req, pPl, pError) EXTERNAL;
  DCL req    WORD;
  DCL pPl    PTR;
  DCL pError PTR;
  END;

/* Periperal Bus Devices */

BubbleDriver: PROCEDURE (req, pPl, pError) EXTERNAL;
  DCL req    WORD;
  DCL pPl    PTR;
  DCL pError PTR;
  END;
$EJECT

$IF notUsed
KeyRoutine: PROCEDURE CLEAN;
  DCL lowercaseBit LIT '20H';

  bootCharacter = CpCatchAll (readKey, 0);
  IF (bootCharacter >= 'A') AND (bootCharacter <= 'Z') THEN
    bootCharacter = bootCharacter OR lowercaseBit;
  END; /* KeyRoutine */
$EJECT
$ENDIF

SetUpPL: PROCEDURE REENTRANT;

  CALL SETB (0, @pl, SIZE (pl));
  IF bootIndex < firstGPiBIndex THEN
    DO;
    entrypoint = @BubbleDriver;
    pl.intAddr = bootIndex;
    END;
  ELSE
    DO;
    entrypoint = @OsDskDriver;
    pl.intAddr = gpibAddresses (bootIndex - 8);
    END;
  END; /* SetUpPL */
$EJECT

SuccessfulRead: PROCEDURE (bytePos, pBuf, length) BOOLEAN REENTRANT;
  DCL bytePos  WORD;
  DCL length   WORD;
  DCL pBuf     PTR;

  DCL i        WORD;
  DCL done     WORD;
  DCL buffer   BASED pBuf (1) BYTE;

  done = 0;
  DO i = 0 TO (length / pageSize) - 1;
    BEGIN
    CALL SetUpPL;
    pl.pBuffer = @buffer (done);
    pl.length = pageSize;
    pl.position = bytePos / pageSize;
    CALL entryPoint (DOUBLE (ddRead), @pl, @error);
    IF error <> eOK THEN
      RETURN (FALSE);
    done = done + pageSize;
    bytePos = bytePos + pageSize;
    END;
  RETURN (TRUE);
  END; /* SuccessfulRead */
$EJECT

TryToBoot: PROCEDURE REENTRANT;
  DCL dummy  WORD;

  error = errors (bootIndex);
  IF error = eOK THEN
    DO;
    CALL SETB (0, @setStatus, SIZE (setStatus));
    CALL SetUpPL;
    pl.pBuffer = @msStatus;
    pl.length = SIZE (msStatus);
    CALL entryPoint (DOUBLE (ddGetStatus), @pl, @error);
    IF error = eOK THEN
      DO;
$IF notUsed
      /* Get More Status to determine if bootable device */

      CALL SetUpPL;
      pl.pBuffer = @moreStatus;
      pl.length = SIZE (moreStatus);
      CALL entryPoint (DOUBLE (ddGetMoreStatus), @pl, @error);
      IF (error <> eOK) OR
         ((moreStatus.deviceType AND 0FH) <> pbusTapeNumber) THEN

      /* End of new Get More Status check */
$ENDIF
        DO;
        error = eOK;
        pageSize = msStatus.pageSize;
        IF SuccessfulRead (0, @buffer, systemPageSize) THEN
          DO;
          IF bootIndex <= lastPBusIndex THEN
            DO; /* Check for valid information */
            IF (physPageZero.validInfoFlag = validPageInfo) AND
               ((physPageZero.rePgmMode AND 1) <> 0) THEN
              DO;
              setStatus.numPages          = physPageZero.numCylinders;
              setStatus.mode              = 80H;
              setStatus.bytesPerPage      = physPageZero.bytesPerPage;
              setStatus.pagesPerTrack     = physPageZero.pagesPerTrack;
              setStatus.tracksPerCylinder = physPageZero.tracksPerCylinder;
              setStatus.numCylinders      = physPageZero.numCylinders;
              setStatus.writeCurrentCyl   = physPageZero.writeCurrentCyl;
              setStatus.preCompCylinder   = physPageZero.preCompCylinder;
              setStatus.controlField      = physPageZero.controlField;
              END;
			ELSE /* Reset default parms for 10 Megabyte drives */
              DO;
			  setStatus.pageSize		  = 512;
			  setStatus.logPageSize		  = 504;
              setStatus.numPages          = 20808;
			  setStatus.bitMapFID		  = 2400H;
			  setStatus.rootDirFID		  = 2420H;
			  setStatus.minDirPages		  = 10;
              setStatus.mode              = 0;
              setStatus.bytesPerPage      = 512;
              setStatus.pagesPerTrack     = 17;
              setStatus.tracksPerCylinder = 4;
			  setStatus.interleave		  = 6;
              setStatus.numCylinders      = 306;
              setStatus.writeCurrentCyl   = 128;
              setStatus.preCompCylinder   = 128;
              setStatus.controlField      = 27H;
              END;
            CALL SetUpPL;
            pl.pBuffer = @setStatus;
            pl.position = NULLDWORD;
            pl.length = SIZE (setStatus);
            pl.mode = 1; /* set status mode */
            CALL entryPoint (DOUBLE (ddWrite), @pl, @error);
			END;
          IF CMPB (@buffer, @('System Disk!'), 12) = NULLWORD THEN
            DO;
            IF SuccessfulRead (bootStart, @buffer, bootLength) THEN
              DO;
              IF (MakeCheckSum (@buffer, bootLength) <> 0) THEN
                 error = eCheckSum;
              END;
            END;
          ELSE
            DO; /* Check for partitioned device */
            IF physPageZero.lastWordFlag = validPartitionPage THEN
              bootPtr = @buffer;
            ELSE
              error = eAccess;
            END;
          END;
        END;

$IF notUsed
      /* ELSE case for Get More Status check */

      ELSE
        error = eInvalidDrive;

      /* end of ELSE case for Get More Status */
$ENDIF

      END;
    ELSE
      DO;
      CALL SetUpPL;
      CALL entrypoint (DOUBLE (ddDeactivate), @pl, @dummy);
      END;
    END;
  END; /* TryToBoot */
$EJECT

DoMasterBoot: PROCEDURE CLEAN;
  /* boot character already set, just make it lower case here */
  bootCharacter = bootCharacter OR lowercaseBit;
  bootPtr = @bootAddress;
$IF notUsed
  DISABLE;
  oldKeyHandler = CpSetKeyHandler (@KeyRoutine);
  ENABLE;
  /* wait for the user to type a key indicating boot device */

  CALL CpDelay (1000);
$ENDIF
  pPromVars = CpAddressOf;

$EJECT

/*             Do Boot (Continued)               */

  DO WHILE TRUE;
    BEGIN
    /* initialize GPIB driver first */

    CALL SetUpPL;
    pl.intAddr = NULLBYTE;
    CALL GPiBDriver (DOUBLE (ddInitialize), @pl, @error);

    /* initialize all other known devices, keeping track of errors */

    DO bootIndex = firstPBusIndex TO lastGPiBIndex;
      BEGIN
      /* This sets the gpib timeout to 7.5 secs. */
      IF bootIndex >= firstGPiBIndex THEN
        DO;
        gpibStatus.request = 2;
        gpibStatus.length  = 7500;
        CALL SetUpPL;
        pl.pBuffer = @gpibStatus;
        pl.length = SIZE (gpibStatus);
        CALL entrypoint (DOUBLE (ddSetStatus), @pl, @error);
        END;
      CALL SetUpPL;
      CALL entrypoint (DOUBLE (ddInitialize), @pl, @errors (bootIndex));
      END;

    /* determine range of devices to try to boot from */

    bootFirst, bootLast = FINDB (@bootCharacters, bootCharacter, numDevices);
    IF bootFirst = NULLWORD THEN
      DO;
      bootFirst = 0;
      IF bootCharacter = 'b' THEN
        bootLast = 7;
      ELSE
        bootLast = 10;
      END;

    /* try booting off of each of these devices */

    DO bootIndex = bootFirst TO bootLast;
      BEGIN
	  bootTrace = bootCharacters (bootIndex);
      CALL TryToBoot;
      IF error = eOK THEN
        DO;
$IF notUsed
        DISABLE;
        oldKeyHandler = CpSetKeyHandler (oldKeyHandler);
        ENABLE;
$ENDIF
        promVars.bootTraceChar = bootCharacters (bootIndex);
        CALL bootPtr;
        END;
      ELSE
        DO;
        CALL ReportError (error);
        CALL CpDelay (2000);
        END;
      END;
    END;
  END; /* DoMasterBoot */
$ELSE
/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

DoMasterBoot: PROCEDURE PUBLIC;

	CALL ReportError (eNotSupport);

END DoMasterBoot;

$ENDIF
$EJECT

/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

/* This is Os.BootSlave.Inc.  It is the part of   */
/* the PROM code that reads in their  			  */
/* operating systems using simple message passing */
/* to a simplified file server on the fs card.    */

/* There are a few conditional statements in this */
/* module that distinguish comm server and appl   */
/* server cards.  If systemType = 0 then it is	  */
/* file server; systemType = 1 is comm server.    */
/* systemType = 2 is appl server.			      */

/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

DoSlaveBoot: PROCEDURE PUBLIC;
	DCL error WORD;
	DO;

	 DISABLE;  /* dont want any more message interrupts to occur */
			   /* zzz may need to set diagnostic message handler too */

$IF testing
	 CALL HexOut(fsProcId);
	 CALL ConLineOut(@(' boot slave ready', cr, lf), 19);
$ENDIF

	 /* switch stack to ensure os code loading doesn't overwrite it */
	 
	 oldStackPtr = STACKPTR;
	 oldStackBase = STACKBASE;

	 pStack = addrBootStack;

	 STACKPTR = LOW (StackOffset) + sizeBootStack;
	 STACKBASE = HIGH (stackOffset);

$IF systemType = 0
    /* initialize GPIB driver first */

    CALL SetUpPL;
    pl.intAddr = NULLBYTE;
    CALL GPiBDriver (DOUBLE (ddInitialize), @pl, @error);

    /* initialize all other known devices, keeping track of errors */

    DO bootIndex = firstPBusIndex TO lastGPiBIndex;
      BEGIN
      /* This sets the gpib timeout to 7.5 secs. */
      IF bootIndex >= firstGPiBIndex THEN
        DO;
        gpibStatus.request = 2;
        gpibStatus.length  = 7500;
        CALL SetUpPL;
        pl.pBuffer = @gpibStatus;
        pl.length = SIZE (gpibStatus);
        CALL entrypoint (DOUBLE (ddSetStatus), @pl, @error);
        END;
      CALL SetUpPL;
      CALL entrypoint (DOUBLE (ddInitialize), @pl, @errors (bootIndex));
      END;
$ENDIF

	 error = ReceiveOsCode;

	 /* now return stack back */

	 STACKPTR = oldStackPtr;
	 STACKBASE = oldStackBase;

	 IF error = 0 THEN
	  DO;
	   /* let OS re-init this interrupt */
	   CALL CpDisableInterrupt (intMessage);
	   /* now "GOTO" to the OS initialization */
	   CALL osHeader.pOs;
	  END;
	 ELSE /* else return to main message handler to get next action */
	  CALL ReportError (error);

	END;
END DoSlaveBoot;


$EJECT
/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

ReceiveOsCode: PROCEDURE WORD CLEAN;
	DCL pMyInterMsg		PTR;
	DCL myInterMsg		BASED pMyInterMsg interCardMsgType;
	DCL pOthersInterMsg	PTR;
	DCL othersInterMsg	BASED pOthersInterMsg interCardMsgType;
	DCL pDiagMsg		PTR;
	DCL diagMsg			BASED pDiagMsg diagnosticMsgType;
	DCL done			BYTE;
	DCL error			WORD;
	DCL bytesRead		WORD;
	DCL recvdLen		WORD;
	DCL timeOut			WORD;
	DCL buf				BASED osHeader.pBuf (1) BYTE;
	DCL checkSum		WORD;
	DCL entry			PTR;
	DO;
	 pMyInterMsg = AddrMsgBlk (cardId,
							   bootCardId);
	 pOthersInterMsg = AddrMsgBlk (bootCardId,
							 	   cardId);
	 pDiagMsg = @myInterMsg.restOfMsg;

	 osHeader.pBuf = nullPtr;
	 done = FALSE;
	 bytesRead = 0;

	 DO WHILE NOT done;
	  BEGIN
	   error = 0;

	   /* wait for receive msg */

	   timeout = 10000;
	   DO WHILE (myInterMsg.typeOfMsg = nullByte) AND (timeOut > 0);
	     CALL Time (50);
	     timeOut = timeOut - 1;
	    END;

	   CALL ConCharOut('.');

	   /* check for errors */

	   IF timeOut = 0 THEN
	    DO;
	     error = eTimeOut;
	    END;
	   ELSE
	    DO;
		 /* make sure message checkSum is valid, and right type of msg */
		 
	     checkSum = MakeCheckSum (@myInterMsg.spare1,
	   							  diagMsg.msgLength + 26);
	     IF checkSum <> myInterMsg.msgCheckSum THEN
		  error = eMsgCheckSum;
	     ELSE IF (diagMsg.ipcFunctionCode <> vipc_DiagnosticMsg) THEN
	      error = eParam;
	     ELSE IF (diagMsg.uMsgClass <> diagMsg_BootInfo) THEN
	      error = eParam;
	    END;

	   /* if no error, process boot data */

	   IF error = 0 THEN
	    DO;
	     /* get length of boot info data */

		 recvdLen = diagMsg.msgLength;

		 /* zero length means end of boot info */

	     IF recvdLen > 0 THEN
	      DO;
		   IF osHeader.pBuf = nullPtr THEN
		    DO;
		     /* if first read, set up os load header */
		     CALL MOVB (@diagMsg.msg,
		   			    @osHeader,
					    SIZE (osHeader));
			 recvdLen = recvdLen - SIZE(osHeader);

			 /* and read remainder of os load data */

		     CALL MOVB (@diagMsg.msg (SIZE (osHeader)),
		   			    @buf,
					    recvdLen);
		   	END;
		   ELSE
		    DO;
			 /* else move boot data into local ram */

		     CALL MOVB (@diagMsg.msg,
		   			    @buf(bytesRead),
					    recvdLen);
			END;

			/* keep track of total bytes */

	       bytesRead = bytesRead + recvdLen;

		  END;
	     ELSE
	      done = TRUE; /* end of boot recving */
	    END;

	   IF error <> eTimeOut THEN
		DO;
	     /* send message acknowledgement */

	     myInterMsg.typeOfMsg = nullByte;
	     othersInterMsg.ackCode = error;

	     OUTPUT (msgIntrPorts + bootCardId) = bootCardId;
		 
		 /* do this to clean up after polled exchange */
		 
		 CALL CpEndOfInterrupt (intMessage);
		 OUTWORD (msgIntReset) = 0;
		END;

	   /* if error encountered, then quit loop */

	   IF (error <> 0) AND (error <> eMsgCheckSum) THEN
		done = TRUE;
	  END;

	 IF error = 0 THEN
	  DO;
	   checkSum = MakeCheckSum (@osHeader.pBuf, 8)
	  				+ MakeCheckSum (osHeader.pBuf, bytesRead);

	   IF osHeader.checkSum <> checkSum THEN
      error = eCheckSum;
	  END;

	 RETURN error;

	END;
END ReceiveOsCode;
$EJECT

/* This routine reports errors in two ways -     */
/*   1. To the console in the format:            */
/*         Cannot boot: xxx - n                  */
/*                                               */
/*   2. To the display in the format:            */
/*         1F xxx BOOTn                          */
/*                                               */
/*       (where xxx = errorCode, n = index)      */

ReportError: PROCEDURE (error) CLEAN;
  DCL error       WORD;

  DCL i           WORD;
  DCL errMsg (14) BYTE;

  errMsg  (0) = cardID + '0';
  errMsg  (1) = cardType;
  errMsg  (2) = ' ';
/* (3) - (5) is where the error digits go */
  errMsg  (6) = ' ';
  errMsg  (7) = 'B';
  errMsg  (8) = 'O';
  errMsg  (9) = 'O';
  errMsg (10) = 'T';
  errMsg (11) = bootTrace;
  errMsg (12) = cr;
  errMsg (13) = lf;

  DO i = 0 TO 2;
    BEGIN
    errMsg (i+3) = error / divisors (i) + '0';
    error = error MOD divisors (i);
    END;

  CALL CpLogError (1, @errMsg);
  CALL ConLineOut (@('Error: '), 7);
  CALL ConLineOut (@errMsg, 14);
  END; /* ReportError */
$EJECT

/*                  Addr Msg Blk                  */

/* This routine returns the address of the message*/
/* block sent by 'fromCardID' to 'cardID'.        */

AddrMsgBlk: PROCEDURE (cardID, fromCardID) PTR CLEAN;
  DCL cardID        WORD;
  DCL fromCardID    WORD;

  DCL relFromCardID WORD;
  DCL pMsgBlk       PTR;
  DCL msgBlkAlias   STRUCTURE
   (offset           WORD,
    segment          WORD) AT (@pMsgBlk);

  relFromCardID = fromCardID;
  IF relFromCardID > cardID THEN
    relFromCardID = relFromCardID - 1;
  msgBlkAlias.segment = 
   startOfCR + sizeBootCR / 16 + (cardID * sizeMsgBlk / 16 * (maxNumCards - 1));
  msgBlkAlias.offset  = relFromCardID * sizeMsgBlk;
  RETURN (pMsgBlk);
  END; /* AddrMsgBlk */

END OsNewBoot;
